﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace RegularExpression
{
    public partial class FindReplaceForm : Form
    {
        
        /// <summary>
        /// Default constructor for the FindReplaceForm.
        /// </summary>
        public FindReplaceForm()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
 
        }

        private int startPos;

        public RegTestForm frmMain;

        private RichTextBox richTxtBox
        {
            get{return frmMain.RichTxtBox;}
        }

        
        private void btnFind_Click(object sender, EventArgs e)
        {
            if (cboFind.Text == "")
            {
                MessageBox.Show("検索する文字列を入力してください。","検索置換");
                return;
            }
            int pos = frmMain.AllText.IndexOf(cboFind.Text, startPos);

            if (pos > -1)
            {
                frmMain.SelStart = pos;

                frmMain.SelLength = cboFind.Text.Length;

                frmMain.RichTxtBox.HideSelection = false;
                frmMain.RichTxtBox.ScrollToCaret();

                startPos = frmMain.SelStart + frmMain.SelLength;

            }
            else
            {
                MessageBox.Show("'" + cboFind.Text + "' が、見つかりません。", "検索");
            }
        }

        private void btnReplaceAll_Click(object sender, EventArgs e)
        {
            if (cboFind.Text == "")
            {
                MessageBox.Show("検索する文字列を入力してください。", "検索置換");
                return;
            }

            frmMain.AllText = frmMain.AllText.Replace(cboFind.Text, cboReplace.Text);
            frmMain.RichTxtBox.Modified = true;
            
            
        }

        
        private void btnClose_Click(object sender, EventArgs e)
        {
            int pos = frmMain.SelStart;

            if (frmMain.SelLength == 0)
            {
                frmMain.SelStart = pos;
            }
            this.Close();
            
        }

        private void btnReplace_Click(object sender, EventArgs e)
        {
            btnFind_Click(sender, e);
            if (frmMain.SelLength != 0)
            {
                if (cboFind.Text.CompareTo(frmMain.SelText) == 0)
                {
                    frmMain.SelText = cboReplace.Text;

                    startPos = frmMain.SelStart;

                    frmMain.RichTxtBox.ScrollToCaret();

                    frmMain.RichTxtBox.Modified = true;
                }
            }
            btnFind_Click(sender, e);
            
        }

    }
}